package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Request;

public class VitalStatusRealDocumentRuleEvaluator extends AbstractDocumentRuleEvaluator {

	@Override
	public boolean isRequired(Request req, DataSource ds, DocumentTemplate temp, Location site, final boolean isIndependentOnly) {
		
		if (isDartRequest(req) == false) {
			return false;
		}
		
		DartRequest dartRequest = (DartRequest)req;
		
		// IRB Approval of Waiver of HIPAA is required of all sites if the HIPAA waiver is true
		if (temp.getName().startsWith("IRB Approval of Waiver of HIPAA") && dartRequest.isHipaaWaiver() == true) {
			return true;
		}

		// Research and Development (RD) Committee Approval is required of all sites
		if (temp.getName().startsWith("Research and Development (RD) Committee Approval")) {
			return true;
		}
		
		// Research Study Institutional Review Board (IRB) Approval is required of all sites
		if (temp.getName().startsWith("Research Study Institutional Review Board (IRB) Approval")) {
			return true;
		}

		Location primarySite = req.getPrimaryLocation();
		if (primarySite != null) {
		
			// Research Request Memo is required for the primary site
			if (temp.getName().startsWith("Research Request Memo") && site.getId() == primarySite.getId()) {
				return true;
			}
			
			// Sample Informed Consent is required for the primary site if the HIPAA patient consent is true
			if (temp.getName().startsWith("Sample Informed Consent") && site.getId() == primarySite.getId() && dartRequest.isHipaaConsent() == true) {
				return true;
			}

            // As per DUA document item 1.10, include DUA if transferredexternal = true
            // Data Use Agreement is required for the primary site
            if (temp.getName().startsWith("Data Use Agreement") && site.getId() == primarySite.getId() && dartRequest.isTransferredExternal() == true) {
                return true;
            }
			
			// Research Protocol is required for the primary site
			if (temp.getName().startsWith("Research Protocol") && site.getId() == primarySite.getId()) {
				return true;
			}

			// CDW-NDS Authorization Form is required for the primary site
			if (temp.getName().startsWith("CDW-Domain Checklist") && site.getId() == primarySite.getId()) {
				return true;
			}

		}

		return false;
	}
	
}
